package com.example.sefinsa_app;

import android.util.Log;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ColaSolicitudes {
    private final Queue<SolicitudSubida> cola = new LinkedList<>();
    private final List<SolicitudSubida> solicitudes;
    private static ColaSolicitudes instance;

    private ColaSolicitudes() {
        solicitudes = new ArrayList<>();
    }

    // Método para obtener la instancia Singleton
    public static synchronized ColaSolicitudes getInstance() {
        if (instance == null) {
            instance = new ColaSolicitudes();
        }
        return instance;
    }
    public void agregarSolicitud(SolicitudSubida solicitud) {
        solicitudes.add(solicitud);
        Log.d("ColaSolicitudes", "Solicitud añadida: " + solicitud);
    }

    public SolicitudSubida obtenerIndexSolicitudyBorrar() {
        if (!solicitudes.isEmpty()) {
            return solicitudes.remove(0);
        }
        return null;
    }
    public SolicitudSubida obtenerPrimeraSolicitud() {
        if (!solicitudes.isEmpty()) {
            return solicitudes.get(0); // Retorna la primera solicitud sin eliminarla.
        }
        return null;
    }

    public void eliminarPrimeraSolicitud() {
        if (!solicitudes.isEmpty()) {
            SolicitudSubida solicitudEliminada = solicitudes.remove(0); // Elimina la primera
            Log.d("ColaSolicitudes", "Solicitud eliminada: " + solicitudEliminada);
        }
    }

    public boolean estaVacia() {
        return solicitudes.isEmpty();
    }

    @Override
    public String toString() {
        return "ColaSolicitudes: " + solicitudes.toString();
    }
}